###############################################################################
#
#--------------------------------------------------------------------------
#
# MAKE file for the PMSPY
#
#--------------------------------------------------------------------------
#
# External Requirements:
# ======================
#
# 1) ENVironment variables that MUST be correctly set
#
#    * NO drives, paths, etc are contained in this MAKE file
#
#    * Before using, the following items must be SET:
#
#      - PATH    = where the utilities "live"       [C, LINK, etc]
#
#      - INCLUDE = all paths to look for #include's [C]
#      - TMP     = "home" for temporary work files  [C]
#
#      - LIB     = all paths to look for LIBraries  [LINK]
#
# 2) ENVironment variables that MAY be set
#
#      - CL      = other CL options...              [C]
#
#                  *** Example: override the C PreProcessor used
#
#                      How To:  set cl=/B1 c:\ibmc2\bin\c1l.exe
#
#--------------------------------------------------------------------------
#
# External MAKE MACROs:
# =====================
#
# wantCV.....generate CODEVIEW information
#
# wantLST....generate LISTING(s)
#
# Sample Usage: make pmspy wantCV=1
#
###############################################################################

#------------------------------------------------------------------------------
# Symbolic names for PRODuct pieces
#------------------------------------------------------------------------------

# this is where C "lives"

cPath   = c:\ibmc2
cInc    = $(cPath)\inc
cBin    = $(cPath)\bin

# this is our PRODuct ID

PROD    = PMSPY

PRODVER = 2.10

PRODDEF = $(PROD).DEF
PRODDLL = $(PROD)DLL.DLL
PRODEXE = $(PROD).EXE
PRODLIB = $(PROD)DLL.LIB
PRODMAP = $(PROD).MAP

PRODSRC = pmspy.c   pmspypro.c   pmspyfil.c   pmspygrp.c   pmspyhel.c   pmspymsg.c   pmspywin.c   pmspyutl.c   pmspyabt.c   pmspyow.c
PRODOBJ = pmspy.obj pmspypro.obj pmspyfil.obj pmspygrp.obj pmspyhel.obj pmspymsg.obj pmspywin.obj pmspyutl.obj pmspyabt.obj pmspyow.obj

PRODHLP = pmspy.hlp pmspyfil.hlp pmspygrp.hlp pmspyow.hlp  pmspy.new pmspydef.pro

#------------------------------------------------------------------------------
# These are the external interface LIBraries we require
#------------------------------------------------------------------------------

EXTERN_LIB      = filedlg
EXTERN_LIB_C    = llibcep
EXTERN_LIB_OS2  = os2

#------------------------------------------------------------------------------
# C parameters
#------------------------------------------------------------------------------

cWARN           = /W3
cMEM            = /Alfu
cOPTS           = /c /I $(cInc) /B1 $(cBin)\c1l.exe /G2s /Zp

# decide about listings..

!ifdef wantLST
cLST            = /Fs /St "PMSPY" /Ss "Version $(PRODVER)" /Sl 132
!endif

# decide about CODEVIEW...

!ifdef wantCV
cOPTS           = $(cOPTS) /Zi /Od
!else
cOPTS           = $(cOPTS) /Ox
!endif

#------------------------------------------------------------------------------
# LINK parameters
#------------------------------------------------------------------------------

lMain           = /NOD/MAP/FARCALL

!ifdef wantCV
lMain           = $(lMain)/COD
!endif

#-------------------------------------------------------------------------------
# *** THIS is THE inference rule to generate our code.... ***
#
# the leading '-' tells MAKE to not abort on a CL error
#
#------------------------------------------------------------------------------

.c.obj:
#
  cl  $(cOPTS) $(cMEM) $(cWARN) $*.c

#-------------------------------------------------------------------------------
#
# *** THIS is THE major dependency rule...it forces anything to happen
#
#------------------------------------------------------------------------------

$(PRODEXE):   pmspy.h             \
              filedlg.h           \
              $(PRODSRC)          \
              $(PRODOBJ)          \
              pmspy.def           \
              pmspy.rc  pmspy.res \
              $(PRODHLP)          \
              pmspy.ico pmspy.ptr \
              $(PRODDLL)
  link $(lMain) @<<
$(PRODOBJ:.obj=)
$(PRODEXE)
$(PRODMAP)
$(EXTERN_LIB)+$(EXTERN_LIB_C)+$(EXTERN_LIB_OS2)+$(PRODLIB)
$(PRODDEF)
<<
  rc pmspy.res

pmspy.obj:    pmspy.c    pmspy.h

pmspyfil.obj: pmspyfil.c pmspy.h

pmspyabt.obj: pmspyabt.c pmspy.h

pmspygrp.obj: pmspygrp.c pmspy.h

pmspyhel.obj: pmspyhel.c pmspy.h

pmspymsg.obj: pmspymsg.c pmspy.h

pmspyow.obj:  pmspyow.c  pmspy.h

pmspypro.obj: pmspypro.c pmspy.h filedlg.h

pmspyutl.obj: pmspyutl.c pmspy.h

pmspywin.obj: pmspywin.c pmspy.h filedlg.h

pmspy.res:    pmspy.rc   pmspy.h pmspy.ico pmspy.ptr $(PRODHLP)
  rc -r pmspy.rc
